/*
 *******************************************************************************
 * L O G I T A G S
 * Software and Programming
 * Dr. Wolfgang Winter
 * Germany
 *
 * All rights reserved
 *
 *******************************************************************************
 */
package com.logitags.cibet.resource;

public enum ParameterType {

   METHOD_PARAMETER,

   HTTP_PARAMETER,

   HTTP_HEADER,

   HTTP_ATTRIBUTE,

   HTTP_BODY,
   /**
    * boolean jdbc parameter
    */
   JDBC_PARAMETER_BOOLEAN,

   JDBC_PARAMETER_BYTE,

   JDBC_PARAMETER_SHORT,

   JDBC_PARAMETER_INT,

   JDBC_PARAMETER_LONG,

   JDBC_PARAMETER_FLOAT,

   JDBC_PARAMETER_DOUBLE,

   JDBC_PARAMETER_BIGDECIMAL,

   JDBC_PARAMETER_STRING,

   JDBC_PARAMETER_BYTES,

   JDBC_PARAMETER_DATE,

   JDBC_PARAMETER_TIME,

   JDBC_PARAMETER_TIMESTAMP,

   JDBC_PARAMETER_OBJECT,

   JDBC_PARAMETER_URL,

   /**
    * jdbc null parameter
    */
   JDBC_PARAMETER_NULL,
   /**
    * jdbc null parameter with specified type and name
    */
   JDBC_PARAMETER_NULL_TYPENAME,
   /**
    * jdbc ascii stream parameter
    */
   JDBC_PARAMETER_ASCIISTREAM,
   /**
    * jdbc ascii stream parameter with specified length
    */
   JDBC_PARAMETER_ASCIISTREAM_INT,
   /**
    * jdbc ascii stream parameter with specified length
    */
   JDBC_PARAMETER_ASCIISTREAM_LONG,
   /**
    * jdbc unicode stream parameter
    */
   JDBC_PARAMETER_UNICODESTREAM,
   /**
    * jdbc binary stream parameter
    */
   JDBC_PARAMETER_BINARYSTREAM,
   /**
    * jdbc binary stream parameter with specified length
    */
   JDBC_PARAMETER_BINARYSTREAM_INT,
   /**
    * jdbc binary stream parameter with specified length
    */
   JDBC_PARAMETER_BINARYSTREAM_LONG,
   /**
    * jdbc object type with specified target sql type
    */
   JDBC_PARAMETER_OBJECT_TARGETSQLTYPE,
   /**
    * jdbc object type with specified target sql type and scale/length
    */
   JDBC_PARAMETER_OBJECT_TARGETSQLTYPE_SCALE,
   /**
    * jdbc character stream parameter
    */
   JDBC_PARAMETER_CHARACTERSTREAM,
   /**
    * jdbc character stream parameter with specified length
    */
   JDBC_PARAMETER_CHARACTERSTREAM_INT,
   /**
    * jdbc character stream parameter with specified length
    */
   JDBC_PARAMETER_CHARACTERSTREAM_LONG,
   /**
    * jdbc NString parameter
    */
   JDBC_PARAMETER_NSTRING,
   /**
    * jdbc ncharacter stream parameter
    */
   JDBC_PARAMETER_NCHARACTERSTREAM,
   /**
    * jdbc ncharacter stream parameter with specified length
    */
   JDBC_PARAMETER_NCHARACTERSTREAM_LONG,

   JDBC_PARAMETER_CLOB,

   JDBC_PARAMETER_NCLOB,
   /**
    * jdbc Reader parameter as CLOB
    */
   JDBC_PARAMETER_CLOB_READER,
   /**
    * jdbc Reader parameter as CLOB with specified length
    */
   JDBC_PARAMETER_CLOB_READER_LONG,
   /**
    * jdbc Reader parameter as NCLOB with specified length
    */
   JDBC_PARAMETER_NCLOB_READER_LONG,
   /**
    * jdbc Reader parameter as NCLOB
    */
   JDBC_PARAMETER_NCLOB_READER,
   /**
    * jdbc inputstream parameter as BLOB with specified length
    */
   JDBC_PARAMETER_BLOB_INPUTSTREAM_LONG,
   /**
    * jdbc inputstream parameter as BLOB
    */
   JDBC_PARAMETER_BLOB_INPUTSTREAM,

   JDBC_PARAMETER_DATE_CAL,

   JDBC_PARAMETER_TIME_CAL,

   JDBC_PARAMETER_TIMESTAMP_CAL,

   JDBC_PARAMETER_BLOB,

   /**
    * One of Statement.execute(), Statement.executeUpdate(), PreparedStatement.execute(),
    * PreparedStatement.executeUpdate(),
    */
   JDBC_STATEMENT_TYPE,

   /**
    * one of columnIndexes, columnNames or autoGeneratedKeys.
    */
   JDBC_STATEMENT_ADDITIONAL_VALUE,

   JPA_HINT,

   JPA_LOCKMODETYPE,

   JPA_NAMED_PARAMETER,

   JPA_INDEXED_PARAMETER,

   JPA_INDEXED_CALENDAR_PARAMETER,

   JPA_INDEXED_DATE_PARAMETER,

   JPA_NAMED_CALENDAR_PARAMETER,

   JPA_NAMED_DATE_PARAMETER,

   JPA_QUERY_TYPE,

   /**
    * result class or mapping
    */
   JPA_QUERY_ADDITIONAL_VALUE,

   /**
    * one of executeUpdate, getSingleResult or getResultList
    */
   JPA_STATEMENT_TYPE,

   JPA_FIRST_RESULT,

   JPA_MAX_RESULT,

   JPA_FLUSH_MODE,

   ENTITY_PROPERTY,

   INTERNAL_PARAMETER,

   ;

}
