-- ----------------------------------------------
-- DROP STATEMENTS
-- ----------------------------------------------

--DROP TABLE CIB_RESOURCEPARAMETER;
--DROP TABLE CIB_ARCHIVE;
--DROP TABLE CIB_CONTROLLABLE;
--DROP TABLE CIB_RESOURCE;
--DROP TABLE CIB_EVENTRESULT;
--DROP TABLE CIB_HISTORY;

CREATE TABLE CIB_RESOURCE ( 
   RESOURCEID VARCHAR(255) NOT NULL, 
   RESOURCETYPE VARCHAR(31) NOT NULL,
   RESULT BLOB(64 K), 
   TARGET VARCHAR(255), 
   TARGETOBJECT BLOB(64 K), 
   PRIMARYKEYID VARCHAR(50), 
   METHOD VARCHAR(255), 
   INVOKERCLASS VARCHAR(255), 
   INVOKERPARAM VARCHAR(255), 
   ENCRYPTED smallint NOT NULL DEFAULT 0,
   KEYREFERENCE VARCHAR(255),
   UNIQUEID VARCHAR(255),
   GROUPID VARCHAR(255),
   PRIMARY KEY (RESOURCEID)
);

CREATE TABLE CIB_RESOURCEPARAMETER ( 
   PARAMETERID VARCHAR(255) NOT NULL, 
   NAME VARCHAR(255) NOT NULL, 
   PARAMETERTYPE VARCHAR(50) NOT NULL, 
   CLASSNAME VARCHAR(255) NOT NULL, 
   ENCODEDVALUE BLOB(64 K), 
   SEQUENCE INTEGER NOT NULL, 
   RESOURCEID VARCHAR(255),
   STRINGVALUE VARCHAR(255),
   CONSTRAINT FK_RESOURCE FOREIGN KEY (RESOURCEID) REFERENCES CIB_RESOURCE (RESOURCEID),
   PRIMARY KEY (PARAMETERID) 
);

CREATE TABLE CIB_ARCHIVE ( 
	ARCHIVEID VARCHAR(255) NOT NULL, 
	REMARK VARCHAR(255), 
	CHECKSUM VARCHAR(255), 
	CONTROLEVENT VARCHAR(50), 
	CREATEUSER VARCHAR(50), 
	CREATEDATE TIMESTAMP, 
	TENANT VARCHAR(255), 
	CASEID VARCHAR(60), 
	EXECUTIONSTATUS VARCHAR(50) NOT NULL, 
	VERSION INTEGER NOT NULL, 
   RESOURCEID VARCHAR(255) NOT NULL, 
   CONSTRAINT FK_ARCHIVE FOREIGN KEY (RESOURCEID) REFERENCES CIB_RESOURCE (RESOURCEID),
	PRIMARY KEY (ARCHIVEID) 
);

CREATE TABLE CIB_CONTROLLABLE ( 
	CONTROLLABLEID VARCHAR(255) NOT NULL, 
	CASEID VARCHAR(60), 
	CONTROLEVENT VARCHAR(50), 
	CREATEUSER VARCHAR(50) NOT NULL, 
	CREATEDATE TIMESTAMP NOT NULL, 
	CREATEADDRESS VARCHAR(255), 
	CREATEREMARK VARCHAR(255), 
	TENANT VARCHAR(255), 
	ACTUATOR VARCHAR(100) NOT NULL, 
	FIRSTAPPROVUSER VARCHAR(50), 
	FIRSTAPPROVALDATE TIMESTAMP, 
	FIRSTAPPROVADDR VARCHAR(255), 
	FIRSTAPPROVREMARK VARCHAR(255), 
	RELEASEUSER VARCHAR(50), 
	RELEASEDATE TIMESTAMP, 
	RELEASEADDRESS VARCHAR(255), 
	RELEASEREMARK VARCHAR(255),
	EXECUTIONSTATUS VARCHAR(50) NOT NULL, 
	VERSION INTEGER NOT NULL, 
	SCHEDULEDDATE TIMESTAMP,
	EXECUTIONDATE TIMESTAMP,
   RESOURCEID VARCHAR(255) NOT NULL, 
   CONSTRAINT FK_CONTROLLABLE FOREIGN KEY (RESOURCEID) REFERENCES CIB_RESOURCE (RESOURCEID),
	PRIMARY KEY (CONTROLLABLEID) 
);

CREATE TABLE CIB_EVENTRESULT (
	EVENTRESULTID VARCHAR(255) NOT NULL,
   PARENTRESULT_ID VARCHAR(255),
   EVENT VARCHAR(50) NOT NULL,
   RESOURC VARCHAR(255),
   SENSOR VARCHAR(50) NOT NULL,
   SETPOINTS VARCHAR(255),
   ACTUATORS VARCHAR(255),
   EXECUTIONSTATUS VARCHAR(50) NOT NULL,
   TRACK_TENANT VARCHAR(255),
   TRACK_USER VARCHAR(50),
   EXECUTIONTIME TIMESTAMP NOT NULL,
   CASEID VARCHAR(60),
   PRIMARY KEY (EVENTRESULTID),
   CONSTRAINT FK_PARENTRESULT FOREIGN KEY (PARENTRESULT_ID) REFERENCES CIB_EVENTRESULT (EVENTRESULTID)
);

CREATE TABLE CIB_HISTORY ( 
   HISTORYID VARCHAR(255) NOT NULL, 
   REMARK VARCHAR(255), 
   CONTROLEVENT VARCHAR(50), 
   CREATEUSER VARCHAR(50), 
   CREATEDATE TIMESTAMP, 
   TENANT VARCHAR(255), 
   CASEID VARCHAR(60), 
   EXECUTIONSTATUS VARCHAR(50) NOT NULL,
   DIFFERENCES CLOB(3000),
   TARGET VARCHAR(255), 
   PRIMARYKEYID VARCHAR(50), 
   VERSION INTEGER NOT NULL, 
   PRIMARY KEY (HISTORYID) 
);

