--DROP TABLE CIB_TCOMPLEXENTITY_EAGER;
--DROP TABLE CIB_TCOMPLEXENTITY_LAZY;
--DROP TABLE CIB_COMPLEXTESTENTITY;
--DROP TABLE cib_syntetic1entity;
--DROP TABLE cib_syntetic2entity;
--DROP TABLE TPSENTITY; 
--DROP TABLE CIB_JMENTITY;
--DROP TABLE CIB_TCOMPLEXENTITY2_EAGER;
--DROP TABLE CIB_TCOMPLEXENTITY2_LAZY;
--DROP TABLE CIB_COMPLEXTESTENTITY2;
--DROP TABLE CIB_TESTENTITY; 

DROP TABLE TEST_COMPANY;
DROP TABLE TEST_MERCHANT;
DROP TABLE TEST_MECHANT2;
DROP TABLE TEST_PRODUCT;
DROP TABLE TEST_PRODUCT2;

-- ----------------------------------------------
-- TABLES FOR TESTING
-- ----------------------------------------------
--
CREATE TABLE CIB_COMPLEXTESTENTITY (
   ID BIGINT generated by default as identity, 
   USERID VARCHAR(255), 
   OWNER VARCHAR(255), 
   COMPVALUE INTEGER NOT NULL, 
   TEN_ID BIGINT, 
   VERSION BIGINT NOT NULL,
   primary key(ID)   
);

CREATE TABLE CIB_TCOMPLEXENTITY_EAGER (
   ID BIGINT NOT NULL, 
   EAGER_ID BIGINT NOT NULL,
   PRIMARY KEY (ID, EAGER_ID)
);

CREATE TABLE CIB_TCOMPLEXENTITY_LAZY (
   ID BIGINT NOT NULL, 
   LAZY_ID BIGINT NOT NULL,
   PRIMARY KEY (ID, LAZY_ID)
);

CREATE TABLE CIB_TESTENTITY (
   ID BIGINT generated by default as identity, 
   NAMEVALUE VARCHAR(255), 
   COUNTER INTEGER NOT NULL, 
   USERID VARCHAR(255), 
   OWNER VARCHAR(255),
   XCALDATE DATE,
   XCALTIMESTAMP TIMESTAMP,
   XDATE DATE,
   XTIME TIME,
   XTIMESTAMP TIMESTAMP,
   primary key(ID)   
);

CREATE TABLE CIB_JMENTITY (
	ID BIGINT generated by default as identity, 
	NAMEVALUE VARCHAR(255), 
	COUNTER INTEGER NOT NULL, 
	USERID VARCHAR(255), 
	OWNER VARCHAR(255)
);

CREATE TABLE TPSENTITY (
	id						BIGINT generated by default as identity,
	langstring			VARCHAR(255),
	bytes					BLOB(64 K),
	datevalue			DATE,
	timevalue			TIME,
	floatvalue			float,
	doublevalue			double,
	timestampvalue		timestamp,
	onebyte				smallint,
	bool					smallint,
	decimalValue		decimal(5,3),
	clobvalue			clob,
	nclobvalue			clob,
	primary key(id)	
);

CREATE TABLE cib_syntetic1entity (
        id BIGINT generated by default as identity,
        intArray BLOB(64 K),
        version timestamp,
        PRIMARY KEY (id)
);    

CREATE TABLE cib_syntetic2entity (
        id VARCHAR(255) NOT NULL,
        PRIMARY KEY (id)
);    

-- ----------------------------------------------
-- DDL-statements for keys
-- ----------------------------------------------

--  constraints do not work with OpenJPA at least with Derby !!
--ALTER TABLE CIB_TCOMPLEXENTITY_EAGER ADD CONSTRAINT SQL090920190805861 UNIQUE (EAGER_ID);

--ALTER TABLE CIB_TCOMPLEXENTITY_LAZY ADD CONSTRAINT SQL090920190805941 UNIQUE (LAZY_ID);

-- foreign
--ALTER TABLE CIB_COMPLEXTESTENTITY ADD CONSTRAINT FK58B2DAA26A921AE FOREIGN KEY (TEN_ID) REFERENCES CIB_TESTENTITY (ID) ON DELETE NO ACTION ON UPDATE NO ACTION;

--ALTER TABLE CIB_TCOMPLEXENTITY_EAGER ADD CONSTRAINT FK4144B93BA7AAACC0 FOREIGN KEY (ID) REFERENCES CIB_COMPLEXTESTENTITY (ID) ON DELETE NO ACTION ON UPDATE NO ACTION;

--ALTER TABLE CIB_TCOMPLEXENTITY_EAGER ADD CONSTRAINT FK4144B93BF78F1AB3 FOREIGN KEY (EAGER_ID) REFERENCES CIB_TESTENTITY (ID) ON DELETE NO ACTION ON UPDATE NO ACTION;

--ALTER TABLE CIB_TCOMPLEXENTITY_LAZY ADD CONSTRAINT FK863F36F1A7AAACC0 FOREIGN KEY (ID) REFERENCES CIB_COMPLEXTESTENTITY (ID) ON DELETE NO ACTION ON UPDATE NO ACTION;

--ALTER TABLE CIB_TCOMPLEXENTITY_LAZY ADD CONSTRAINT FK863F36F1388AFAF7 FOREIGN KEY (LAZY_ID) REFERENCES CIB_TESTENTITY (ID) ON DELETE NO ACTION ON UPDATE NO ACTION;

CREATE TABLE CIB_COMPLEXTESTENTITY2 (
        ID BIGINT NOT NULL GENERATED BY DEFAULT AS IDENTITY,
        COMPVALUE INTEGER NOT NULL,
        OWNER VARCHAR(255),
        VERSION INTEGER NOT NULL,
        TEN_ID BIGINT,
        SELFOWNER2 varchar(255),
        PRIMARY KEY (ID)
);
    
CREATE TABLE CIB_TCOMPLEXENTITY2_EAGER (
        ID BIGINT NOT NULL,
        EAGER_ID BIGINT NOT NULL,
        PRIMARY KEY (ID, EAGER_ID)
--        , CONSTRAINT FK_FP3H9S0WM9ES6FPXQ84WYNWP FOREIGN KEY (ID) REFERENCES CIB_COMPLEXTESTENTITY2
--        (ID),
--        CONSTRAINT FK_INKOV9HS3N9KHP1JAC7MB2UCI FOREIGN KEY (EAGER_ID) REFERENCES CIB_TESTENTITY
--        (ID),
--        CONSTRAINT UK_INKOV9HS3N9KHP1JAC7MB2UCI UNIQUE (EAGER_ID)
);
    
CREATE TABLE CIB_TCOMPLEXENTITY2_LAZY (
        ID BIGINT NOT NULL,
        LAZY_ID BIGINT NOT NULL,
        PRIMARY KEY (ID, LAZY_ID)
--        , CONSTRAINT FK_3MSLLAO5QMO0671UMW367O8BA FOREIGN KEY (LAZY_ID) REFERENCES CIB_TESTENTITY (ID
--        ),
--        CONSTRAINT FK_CSXPBTAYY9136JE9BM7KY4EU9 FOREIGN KEY (ID) REFERENCES CIB_COMPLEXTESTENTITY2
--        (ID),
--        CONSTRAINT UK_3MSLLAO5QMO0671UMW367O8BA UNIQUE (LAZY_ID)
);    

CREATE TABLE TEST_COMPANY (
        ID VARCHAR(255) NOT NULL,
        TENANT VARCHAR(255),
        PRIMARY KEY (ID)
);
CREATE TABLE TEST_MERCHANT (
        ID BIGINT NOT NULL,
        TENANT VARCHAR(255),
        PARENT_ID BIGINT,
        PRIMARY KEY (ID)
);
CREATE TABLE TEST_MERCHANT2 (
        ID BIGINT NOT NULL,
        TENANT VARCHAR(255),
        COMPANY_ID VARCHAR(255),
        PARENT_ID BIGINT,
        PRIMARY KEY (ID)
);
CREATE TABLE TEST_PRODUCT (
        ID VARCHAR(255) NOT NULL,
        TENANT VARCHAR(255),
        PRODUCTNAME VARCHAR(255),
        PRIMARY KEY (ID)
);
CREATE TABLE TEST_PRODUCT2 (
        ID VARCHAR(255) NOT NULL,
        TENANT INTEGER,
        PRIMARY KEY (ID)
);
