--DROP TABLE CIB_TCOMPLEXENTITY_EAGER;
--DROP TABLE CIB_TCOMPLEXENTITY_LAZY;
--DROP TABLE CIB_COMPLEXTESTENTITY;
--DROP TABLE cib_syntetic1entity;
--DROP TABLE cib_syntetic2entity;
--DROP TABLE TPSENTITY; 
--DROP TABLE CIB_JMENTITY;
--DROP TABLE CIB_TCOMPLEXENTITY2_EAGER;
--DROP TABLE CIB_TCOMPLEXENTITY2_LAZY;
--DROP TABLE CIB_COMPLEXTESTENTITY2;
--DROP TABLE CIB_TESTENTITY; 

-- ----------------------------------------------
-- TABLES FOR TESTING
-- ----------------------------------------------
CREATE TABLE CIB_COMPLEXTESTENTITY (
    ID NUMBER(19,0) NOT NULL, 
    USERID VARCHAR2(50), 
    OWNER VARCHAR2(255), 
    COMPVALUE NUMBER(10,0) NOT NULL, 
    TEN_ID NUMBER(19,0),
    VERSION NUMBER(19,0) NOT NULL, 
    PRIMARY KEY (ID)
);

CREATE TABLE CIB_TCOMPLEXENTITY_EAGER (
    ID NUMBER(19,0) NOT NULL, 
    EAGER_ID NUMBER(19,0) NOT NULL, 
    PRIMARY KEY (ID, EAGER_ID)
);

CREATE TABLE CIB_TCOMPLEXENTITY_LAZY (
    ID NUMBER(19,0) NOT NULL, 
    LAZY_ID NUMBER(19,0) NOT NULL, 
    PRIMARY KEY (ID, LAZY_ID)
);     

CREATE TABLE CIB_TESTENTITY (
        ID NUMBER(19) NOT NULL,
        NAMEVALUE VARCHAR2(255),
        COUNTER NUMBER(10) NOT NULL,
        USERID VARCHAR2(50),
        OWNER VARCHAR2(255),
        XCALDATE DATE,
        XCALTIMESTAMP TIMESTAMP(6),
        XDATE DATE,
        XTIME DATE,
        XTIMESTAMP TIMESTAMP(6),
        PRIMARY KEY (ID)
);

CREATE TABLE CIB_JMENTITY (
	ID number(19,0), 
	NAMEVALUE VARCHAR(255), 
	COUNTER number(10) NOT NULL, 
	USERID VARCHAR(255), 
	OWNER VARCHAR(255)
);


CREATE TABLE TPSENTITY (
	id						NUMBER(19,0) NOT NULL,
	langstring			VARCHAR2(255),
	bytes					BLOB,
	datevalue			DATE,
	timevalue			TIMESTAMP,
	floatvalue			float,
	doublevalue			NUMBER(19,6),
	timestampvalue		TIMESTAMP,
	onebyte				smallint,
	bool					char(1),
	decimalValue		decimal(5,3),
	clobvalue			clob,
	nclobvalue			nclob,
	primary key(id)	
);

CREATE TABLE cib_syntetic1entity (
        id NUMBER(19,0) NOT NULL,
        intArray BLOB,
        version TIMESTAMP,
        PRIMARY KEY (id)
);    

CREATE TABLE cib_syntetic2entity (
        id VARCHAR2(255) NOT NULL,
        PRIMARY KEY (id)
);    
 

CREATE TABLE CIB_COMPLEXTESTENTITY2 (
    ID NUMBER(19,0) NOT NULL, 
    OWNER VARCHAR2(255), 
    COMPVALUE NUMBER(10,0) NOT NULL, 
    TEN_ID NUMBER(19,0),
    VERSION NUMBER(19,0) NOT NULL, 
    SELFOWNER2 varchar(255),
    PRIMARY KEY (ID)
);

CREATE TABLE CIB_TCOMPLEXENTITY2_EAGER (
    ID NUMBER(19,0) NOT NULL, 
    EAGER_ID NUMBER(19,0) NOT NULL, 
    PRIMARY KEY (ID, EAGER_ID)
);

CREATE TABLE CIB_TCOMPLEXENTITY2_LAZY (
    ID NUMBER(19,0) NOT NULL, 
    LAZY_ID NUMBER(19,0) NOT NULL, 
    PRIMARY KEY (ID, LAZY_ID)
);     

-- ----------------------------------------------
-- DDL-statements for foreign keys
-- ----------------------------------------------

ALTER TABLE CIB_COMPLEXTESTENTITY ADD CONSTRAINT FK58B2DAA26A921AE FOREIGN KEY (TEN_ID) REFERENCES CIB_TESTENTITY (ID);
ALTER TABLE CIB_TCOMPLEXENTITY_EAGER ADD CONSTRAINT FK4144B93BA7AAACC0 FOREIGN KEY (ID) REFERENCES CIB_COMPLEXTESTENTITY (ID);
ALTER TABLE CIB_TCOMPLEXENTITY_EAGER ADD CONSTRAINT FK4144B93BF78F1AB3 FOREIGN KEY (EAGER_ID) REFERENCES CIB_TESTENTITY (ID);
ALTER TABLE CIB_TCOMPLEXENTITY_LAZY ADD CONSTRAINT FK863F36F1A7AAACC0 FOREIGN KEY (ID) REFERENCES CIB_COMPLEXTESTENTITY (ID);
ALTER TABLE CIB_TCOMPLEXENTITY_LAZY ADD CONSTRAINT FK863F36F1388AFAF7 FOREIGN KEY (LAZY_ID) REFERENCES CIB_TESTENTITY (ID);

ALTER TABLE CIB_COMPLEXTESTENTITY2 ADD CONSTRAINT FK_CC1 FOREIGN KEY (TEN_ID) REFERENCES CIB_TESTENTITY (ID);
ALTER TABLE CIB_TCOMPLEXENTITY2_EAGER ADD CONSTRAINT FK_CC2 FOREIGN KEY (ID) REFERENCES CIB_COMPLEXTESTENTITY2 (ID);
ALTER TABLE CIB_TCOMPLEXENTITY2_EAGER ADD CONSTRAINT FK_CC3 FOREIGN KEY (EAGER_ID) REFERENCES CIB_TESTENTITY (ID);
ALTER TABLE CIB_TCOMPLEXENTITY2_LAZY ADD CONSTRAINT FK_CC4 FOREIGN KEY (ID) REFERENCES CIB_COMPLEXTESTENTITY2 (ID);
ALTER TABLE CIB_TCOMPLEXENTITY2_LAZY ADD CONSTRAINT FK_CC5 FOREIGN KEY (LAZY_ID) REFERENCES CIB_TESTENTITY (ID);
